<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 03.12.13 12:44
 */

namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use VM\ApiBundle\Entity\Application;
use VM\ApiBundle\Entity\ApplicationRole;
use VM\ApiBundle\Entity\User;

use VM\ApiBundle\Services\PasswordEncoder;

class LoadUsersData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * @var array
     */
    protected $applications = array(
        array('symbol' => 'GAME', 'description' => 'Gra biznesowa', 'roles' => array(
            array('symbol' => 'ROLE_TEACHER', 'description' => 'Użytkownik o wyższych uprawnieniach niż uczeń - nauczyciel',
                'users' => array(
                    array('name' => 'Jarosław', 'surname' => 'Cupryś', 'email' => 'j.cuprys@ur.edu.pl'),
                    array('name' => 'Artur', 'surname' => 'Kuliński', 'email' => 'akul@univ.rzeszow.pl'),
                    array('name' => 'Katarzyna', 'surname' => 'Puchalska', 'email' => 'k_puch@univ.rzeszow.pl')
                )
            )
        ))
    );


    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $Manager)
    {
        $PasswordEncoder = new PasswordEncoder();

        foreach($this->applications as $appData)
        {
            $Application = $Manager->getRepository('VMApiBundle:Application')->findOneBySymbol($appData['symbol']);

            foreach($appData['roles'] as $appRoleData)
            {
                $ApplicationRole = $Manager->getRepository('VMApiBundle:ApplicationRole')->findOneBy(array('appId' => $Application->getId(), 'symbol' => $appRoleData['symbol']));

                foreach($appRoleData['users'] as $userData)
                {
                    $User = new User();
                    $User->setName($userData['name']);
                    $User->setSurname($userData['surname']);
                    $User->setUsername($userData['email']);
                    $User->setEmail($userData['email']);

                    $salt = md5(rand(1, 10000000));
                    $User->setSalt($salt);
                    $User->setEnabled(true);
//                    $User->setPlainPassword($PasswordEncoder->encodePassword($userData['surname'], $salt));
                    $User->setPlainPassword(md5($userData['surname']));

                    $User->addAppRole($ApplicationRole);
                    $ApplicationRole->addUser($User);

                    $Manager->persist($User);
                }
            }

            $Manager->flush();
        }
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 20;
    }
}